/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.common.MakeTempCardInHandAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class DayOfTheDead
extends AbstractCard {
    public static final String ID = "DayOfTheDead";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("DayOfTheDead");
    public static final String NAME = "DayOfTheDead";
    public static final String DESCRIPTION = " Fill your hand with random Ammo cards until full. Exhaust.";
    private static final int COST = 2;
    private static final int POOL = 1;

    public DayOfTheDead() {
        super("DayOfTheDead", "DayOfTheDead", null, 2, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.SELF, 1);
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        int cardsToGain = 10 - p.hand.size();
        for (int i = 0; i < cardsToGain; ++i) {
            AbstractCard c = AbstractDungeon.returnTrulyRandomCardWithSubtype(AbstractCard.CardSubType.AMMO).makeCopy();
            AbstractDungeon.actionManager.addToBottom(new MakeTempCardInHandAction(c, true));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new DayOfTheDead();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBaseCost(1);
        }
    }
}

